#pragma once

// by HD...

#include <process.h>


typedef int (CALLBACK *CALLBACK_THREADPOOL)(void *pCallbackData, void *pData, int nSize);


class CIOCPThreadPool
{
public:
	CIOCPThreadPool(void)
	{
		m_hiocp = INVALID_HANDLE_VALUE;
		m_nThreadCount = 0;
		m_phThread = NULL;

		mf_pCallback = NULL;
		m_pCallbackData = NULL;
	}

	virtual ~CIOCPThreadPool(void)
	{
		UninitThreadPool();
	}

	int InitThreadPool(CALLBACK_THREADPOOL pCallback, void *pCallbackData, int nThreadCount)
	{
		if(m_hiocp != INVALID_HANDLE_VALUE)
			return 1;

		if(nThreadCount == 0)
		{
			SYSTEM_INFO systemInfo={0};
			GetSystemInfo( &systemInfo );
			m_nThreadCount = systemInfo.dwNumberOfProcessors << 1;
		}
		else
		{
			m_nThreadCount = nThreadCount;
		}

		m_hiocp = CreateIoCompletionPort( INVALID_HANDLE_VALUE, NULL, 0, m_nThreadCount );
		if(m_hiocp == INVALID_HANDLE_VALUE)
		{
			TRACE( _T("CreateIoCompletionPort() error!! [%ld]\n" ), GetLastError() );
			return 2;
		}

		mf_pCallback = pCallback;
		m_pCallbackData = pCallbackData;

		m_phThread = new HANDLE[m_nThreadCount];
		memset(m_phThread, 0, sizeof HANDLE *m_nThreadCount);

		for( int i=0; i<(int)m_nThreadCount; i++ )
			m_phThread[i] = (HANDLE)_beginthreadex( NULL, 0, WorkThread, (LPVOID)this, 0, NULL );

		return 0;
	}

	void UninitThreadPool()
	{
		if(m_hiocp == INVALID_HANDLE_VALUE)
			return ;

		int i=0;
		for(i=0;i<(int)m_nThreadCount; ++i)
			PostQueuedCompletionStatus(m_hiocp, 0, 0, NULL);

		WaitForMultipleObjects(m_nThreadCount, m_phThread, TRUE, INFINITE);

		for(i=0;i<(int)m_nThreadCount; ++i)
			CloseHandle(m_phThread[i]);

		delete [] m_phThread;

		CloseHandle(m_hiocp);
		m_hiocp = INVALID_HANDLE_VALUE;
		m_phThread = NULL;
	}

	BOOL PostQueued(void *pData, DWORD dwSize)
	{
		void *p = new char[dwSize];
		if(p == NULL)
			return FALSE;

		memcpy(p, pData, dwSize);

		return PostQueuedCompletionStatus(m_hiocp, dwSize, (ULONG_PTR)p, NULL);
	}


private:
	HANDLE m_hiocp;
	int m_nThreadCount;
	HANDLE *m_phThread;

	CALLBACK_THREADPOOL mf_pCallback;
	void * m_pCallbackData;


	static unsigned int CALLBACK WorkThread(void *pv)
	{
		int nrs = 0;
		try
		{
			nrs = ((CIOCPThreadPool*)pv)->WorkProc();
		}
		catch(...)
		{
			nrs = -1;
		}
		_endthreadex(nrs);
		return nrs;
	}

	int WorkProc()
	{
		BOOL bStatus = FALSE;
		DWORD dwIOSize=0, *pKey=NULL;
		LPOVERLAPPED lpov = NULL;

		::CoInitialize(NULL);

		for(;;)
		{
			bStatus = GetQueuedCompletionStatus(m_hiocp, &dwIOSize, (LPDWORD)&pKey, &lpov, INFINITE );

			if(bStatus == FALSE)
			{
				DWORD dwError = GetLastError();
				if(dwError == 6)
					break;

				continue;
			}
			if(pKey == NULL)
				break;

			mf_pCallback(m_pCallbackData, pKey, (int)dwIOSize);

			delete [] pKey;
		}

		::CoUninitialize();

		return 0;
	}


};

